/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.metrics;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.List;
import org.simmetrics.ListDistance;
import org.simmetrics.StringDistance;

public final class HammingDistance {
    private HammingDistance() {
    }

    public static <T> ListDistance<T> forList() {
        return new HammingListDistance();
    }

    public static StringDistance forString() {
        return new HammingStringDistance();
    }

    private static final class HammingListDistance<T>
    implements ListDistance<T> {
        HammingListDistance() {
        }

        @Override
        public float distance(List<T> a, List<T> b) {
            Preconditions.checkArgument((a.size() == b.size() ? 1 : 0) != 0);
            if (a.isEmpty()) {
                return 0.0f;
            }
            int distance = 0;
            Iterator<T> aItt = a.iterator();
            Iterator<T> bItt = b.iterator();
            while (aItt.hasNext()) {
                if (Objects.equal(aItt.next(), bItt.next())) continue;
                ++distance;
            }
            return distance;
        }

        public String toString() {
            return "HammingListDistance";
        }
    }

    private static final class HammingStringDistance
    implements StringDistance {
        HammingStringDistance() {
        }

        @Override
        public float distance(String a, String b) {
            Preconditions.checkArgument((a.length() == b.length() ? 1 : 0) != 0);
            if (a.isEmpty()) {
                return 0.0f;
            }
            int distance = 0;
            int length = a.length();
            for (int i = 0; i < length; ++i) {
                if (a.charAt(i) == b.charAt(i)) continue;
                ++distance;
            }
            return distance;
        }

        public String toString() {
            return "HammingStringDistance";
        }
    }
}

